%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This work by EPFL STI IBI LBNI is licensed under 
% a Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
% Based on a work at http://lbni.epfl.ch/.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function [ improv_param, peak_gaussian_std ] = check_improvement_ok( im , previous_gaussian_std, min_spacing_stdev, max_spacing_stdev, amplitude_fract)
%CHECK_IMPROVEMENT: This function checks if the image improved or not by
%comparing for each peak the previous and the new lower and upper bounds of
%the peak.
%   The previous bounds of the peaks(t_hist_lower_x, t_hist_upper_x) must
%   be sent to the function.
%   The function computes the new bounds of the peaks.
%   The output of the function is a number that is positive in case of
%   improvement, and negative else.

        
        improv_param                                = 0;
            
        [height position]                           = hist(reshape(im(:,:),size(im,1)*size(im,2),1),256);                                          % Calculates the histogram of the corrected height data (First image only)
        height                                      = smooth(height,4,'loess');
        [peak_height peak_index]                    = findpeaks(height,'MinpeakDistance', 8,'Sortstr','descend');                                          % Finds up to four peaks in the corrected image to identify different terraces

        peak_index                                  = sort(peak_index(1:3),'ascend');
        peak_height                                 = height(peak_index);
        
        func_form                                   = [];                                                                                                    % Initializes the functional form to fit
        t_hist_lower_a                              = zeros(1,min(3,length(peak_height)));                                                                 % Initializes the lower bounds for fitting
        t_hist_lower_s                              = zeros(1,min(3,length(peak_height)));                                                                 % Initializes the lower bounds for fitting   
        t_hist_lower_x                              = zeros(1,min(3,length(peak_height)));                                                                 % Initializes the lower bounds for fitting

        t_hist_upper_a                              = zeros(1,min(3,length(peak_height)));                                                                 % Initializes the upper bounds for fitting
        t_hist_upper_s                              = zeros(1,min(3,length(peak_height)));                                                                 % Initializes the upper bounds for fitting
        t_hist_upper_x                              = zeros(1,min(3,length(peak_height)));                                                                 % Initializes the upper bounds for fitting

        t_hist_start_a                              = zeros(1,min(3,length(peak_height)));                                                                 % Initializes the start point for fitting
        t_hist_start_s                              = zeros(1,min(3,length(peak_height)));                                                                 % Initializes the start point for fitting
        t_hist_start_x                              = zeros(1,min(3,length(peak_height)));                                                                 % Initializes the start point for fitting

        for i                                       = 1:min(3,length(peak_height))                                                                         % Loops for the minimum of the number of peaks or 3
            t_hist_lower_a(i)                       = (1-amplitude_fract)*peak_height(i);                                                                  % Sets the lower amplitude bound for the fit
            t_hist_lower_s(i)                       = min_spacing_stdev;                                                                                  % Sets the lower standard deviation
            t_hist_lower_x(i)                       = position(peak_index(i))-3.5/256;                                                                   % Sets the lower center relative to the peak

            t_hist_upper_a(i)                       = (1+amplitude_fract)*peak_height(i);                                                                  % Sets the upper amplitude bound for the fit
            t_hist_upper_s(i)                       = max_spacing_stdev;                                                                                % Sets the upper standard deviation
            t_hist_upper_x(i)                       = position(peak_index(i))+3.5/256;                                                                   % Sets the upper center relative to the peak

            t_hist_start_a(i)                       = 1.00*peak_height(i);                                                                                 % Sets the starting amplitude bound for the fit
            t_hist_start_s(i)                       = (min_spacing_stdev+max_spacing_stdev)/2;                                                         % Sets the starting standard deviation
            t_hist_start_x(i)                       = position(peak_index(i));                                                                           % Sets the starting center relative at the peak
            func_form                               = [func_form,'a',num2str(i),'*exp(-(x-x',num2str(i),')^2/(2*(s',num2str(i),')^2))'];                     % Generates the functional form to fit                                                  
            if i < min(3,length(peak_height))
                func_form                           = [func_form,'+'];                                                                                       % Generates the functional form to fit
            end
        end
        

        % Combines all the bouds into a form for the fits
        t_hist_lower                                = [t_hist_lower_a,t_hist_lower_s,t_hist_lower_x];                                                        % Combines the lower bounds
        t_hist_upper                                = [t_hist_upper_a,t_hist_upper_s,t_hist_upper_x];                                                        % Combines the upper bounds
        t_hist_start                                = [t_hist_start_a,t_hist_upper_s,t_hist_upper_x];                                                        % Combines the start point

        % Fits the data with the speficied conditions
        t_hist = fitoptions(    'Method','NonlinearLeastSquares',...                                                                                             % Sets the conditions for fitting
                                'Lower',      t_hist_lower,...
                                'Upper',      t_hist_upper,...
                                'Startpoint', t_hist_start,...
                                'MaxIter',    1e2,...
                                'MaxFunEvals',3e2);
        f_Number_hist                               = fittype(func_form,  'options' ,t_hist);
        [peak_gaussian,peak_gaussian_gof]           = fit( position',...                                                                                    % Fits the data
                                                           height,...
                                                           f_Number_hist);
                                                        
        % Combines all the amplitudes, the positions and the standard
        % deviations into one vector
         peak_gaussian_ampl                         = [];
         peak_gaussian_pos                          = [];
         peak_gaussian_std                          = [];
         for i                                      = 1:min(3,length(peak_height))
            eval(['peak_gaussian_ampl(', num2str(i), ')= peak_gaussian.a', num2str(i), ';']);
            eval(['peak_gaussian_pos(',  num2str(i), ')= peak_gaussian.x', num2str(i), ';']);
            eval(['peak_gaussian_std(',  num2str(i), ')= peak_gaussian.s', num2str(i), ';']);
         end
        
         
         for i                                      = 1:min(3,length(previous_gaussian_std))
            disp(['---Peak number ', num2str(i), '---'])
           
            peak_weight(i)                          = peak_gaussian_ampl(i);                  % Weight taking into account the amplitude of the peak; determines the "importance" of the peak
            disp(['Peak amplitude = ', num2str(peak_gaussian_ampl(i)), '; Previous std = ', num2str(previous_gaussian_std(i)), '; Current std =' ,  num2str(peak_gaussian_std(i))])
            
            if peak_gaussian_std(i) < previous_gaussian_std(i)                                    % If the peak after polymomial flattening is sharper than the the one before flattening
                  improv_param                      = improv_param + peak_weight(i)                                                                       % The value of the improvement parameter increases
            else                                                                                                                    % Else
                  improv_param                      = improv_param - peak_weight(i)                                                                       % The value of the improvement parameter decreases
            end
        end      
       
        
end

